---
obsidianUIMode: preview
---

When GMs design encounters, we often have a concept that includes the number of foes the characters will face. An encounter might feature a squad of four monsters going against the characters one-to-one, or perhaps a larger force of six or eight swarming the heroes. Or maybe we want a stronger creature, acting as a boss or captain, with only a few other creatures to back them up. And, of course, it's always fun for characters to face a single dangerous foe.

This section provides guidelines for combining creatures of different challenge ratings to enable these various concepts. Simply pick your concept, consult the appropriate table for the number of characters in your game, look up their average character level, and you have the monster challenge ratings you need to build different types of encounters and boss scenarios. You can then use the other tips in this document to make encounters unique.

## Hard Challenge Level Monster Combinations

The challenge ratings in the tables are geared toward creating encounters that are a hard challenge. The encounter concepts are set up along specific lines, reflecting some of the most common—and fun—combinations of foes.

***One Monster.*** The leftmost column notes the challenge rating expected for a solo creature whose statistics and capabilities can build a hard challenge. Running an encounter for a single solo monster is always tricky, so make sure an intended solo creature is up to the challenge.

***Two, Four, Six, Eight, or Twelve Monsters.*** The other columns under Monsters of the Same CR allow you to challenge the characters with a number of creatures of the same CR, and usually of the same type. For example, a hard challenge for four 4th-level characters could constitute six scouts (CR 1/2) or two ogres (CR 2).

Using creatures of the same type allows you to quickly and simply tell a story as the characters find themselves in an ogre market cavern, a caravan under attack, the room with mimics, and so forth. Using the same monsters also lets you focus on a single stat block for ease of play.

***One Boss + X Monsters.*** Encounter concepts often suggest a group of creatures led by a more formidable leader. Each of the Boss Scenarios columns pairs up one boss and a number of subordinates of lower challenge rating. For example, a group of four 3rd-level characters could face one boss of CR 2 and two subordinates of CR 1/2-perhaps an ogre explorer and the two rust monsters they've befriended.

The rightmost column under Boss Scenarios builds encounters with eight minions, two lieutenants of a higher challenge rating, and one boss whose CR is higher again.

### Using the Tables

To build encounters using the tables, follow these steps:

* Select the appropriate table, based on the number of characters in the party—four, five, or six.
* In the leftmost column of the selected table, find the row containing the average character level for all the characters. (To find the average, add up all the characters' levels, then divide by the number of characters and round down.)
* Follow that row to the column containing the encounter concept you wish to use. For example, to create an encounter with one boss and three lesser monsters, you'd go to the 1 Boss + 3 Monsters column.
* The entry you cross-referenced notes the challenge ratings of the creature or creatures in your encounter. If a multiplier is indicated, that's the number of monsters for the preceding CR. For example, wanting to challenge four 3rd-level characters with the encounter concept of one boss and three monsters yields an entry of "2 + 1/4 (×3)." This indicates that you want one CR 2 creature acting as the boss, and three CR 1/4 creatures acting as subordinates.
* Choose your monsters! If you're building a quick encounter, the recommendations in "Monsters by Adventure Location" are a good starting point.

### Scaling Encounters

Each of the tables is intended to build a hard encounter. However, you can easily build encounters with other challenge levels in mind by adding or subtracting a modifier to the party's average character level:

* For a deadly challenge: +1 or +2
* For a medium challenge: −2
* For an easy challenge: −4

For example, when building an encounter for four 10th-level characters, you could use the row for 8th-level characters to create a medium challenge.

In all cases, be cautious with scaling. Encounters of certain types and at certain levels will be harder or easier than the approximation would indicate. Always be prepared to adjust encounters on the fly.

## Four Characters (Hard Challenges)

|                 | Monsters of the Same CR |     |     |     |     |     | Boss Scenarios      |                     |                       |                                    |
| --------------- | ----------------------- | --- | --- | --- | --- | --- | ------------------- | ------------------- | --------------------- | ---------------------------------- |
| Character Level | 1                       | 2   | 4   | 6   | 8   | 12  | 1 Boss + 2 Monsters | 1 Boss + 3 Monsters | 1 Boss + 4 Underlings | 1 Boss + 2 Lieutenants + 8 Minions |
| 1               | 1                       | 1/2 | 1/8 | 1/8 | 0   | -   | 1/2 + 1/8 (x2)      | 1/2 + 1/8 (x3)      | 1/4 + 1/8 (x4)        | -                                  |
| 2               | 3                       | 1   | 1/2 | 1/4 | 1/8 | 0   | 1 + 1/4 (x2)        | 1 + 1/4 (x3)        | 1 + 1/8 (x4)          | 1/2 + 1/4 (x2) + 0 (x8)            |
| 3               | 4                       | 2   | 1/2 | 1/2 | 1/4 | 1/8 | 2 + 1/2 (x2)        | 2 + 1/4 (x3)        | 2 + 1/4 (x4)          | 1 + 1/4 (x2) + 0 (x8)              |
| 4               | 5                       | 2   | 1   | 1/2 | 1/2 | 1/4 | 2 + 1 (x2)          | 2 + 1/2 (x3)        | 3 + 1/4 (x4)          | 2 + 1/4 (x2) + 0 (x8)              |
| 5               | 8                       | 4   | 2   | 1   | 1   | 1/2 | 4 + 2 (x2)          | 4 + 1 (x3)          | 4 + 1 (x4)            | 3 + 1/2 (x2) + 1/4 (x8)            |
| 6               | 9                       | 5   | 3   | 2   | 1   | 1/2 | 5 + 2 (x2)          | 4 + 2 (x3)          | 5 + 1 (x4)            | 4 + 1 (x2) + 1/4 (x8)              |
| 7               | 10                      | 6   | 3   | 2   | 1   | 1/2 | 5 + 3 (x2)          | 5 + 2 (x3)          | 6 + 1 (x4)            | 4 + 1 (x2) + 1/2 (x8)              |
| 8               | 12                      | 7   | 3   | 3   | 2   | 1   | 7 + 3 (x2)          | 5 + 3 (x3)          | 6 + 2 (x4)            | 4 + 2 (x2) + 1/2 (x8)              |
| 9               | 12                      | 8   | 4   | 3   | 2   | 1   | 7 + 4 (x2)          | 6 + 3 (x3)          | 6 + 3 (x4)            | 5 + 2 (x2) + 1/2 (x8)              |
| 10              | 14                      | 8   | 4   | 3   | 2   | 2   | 7 + 5 (x2)          | 6 + 4 (x3)          | 7 + 3 (x4)            | 5 + 2 (x2) + 1 (x8)                |
| 11              | 16                      | 9   | 5   | 4   | 3   | 2   | 8 + 5 (x2)          | 6 + 5 (x3)          | 9 + 3 (x4)            | 6 + 3 (x2) + 1 (x8)                |
| 12              | 18                      | 11  | 6   | 5   | 4   | 2   | 9 + 7 (x2)          | 8 + 5 (x3)          | 8 + 5 (x4)            | 7 + 4 (x2) + 1 (x8)                |
| 13              | 19                      | 12  | 7   | 5   | 4   | 3   | 11 + 7 (x2)         | 10 + 6 (x3)         | 10 + 5 (x4)           | 8 + 4 (x2) + 2 (x8)                |
| 14              | 20                      | 13  | 8   | 6   | 4   | 3   | 11 + 8 (x2)         | 10 + 7 (x3)         | 10 + 6 (x4)           | 8 + 5 (x2) + 2 (x8)                |
| 15              | 21                      | 14  | 8   | 7   | 5   | 4   | 12 + 9 (x2)         | 10 + 8 (x3)         | 10 + 7 (x4)           | 9 + 5 (x2) + 2 (x8)                |
| 16              | 22                      | 15  | 9   | 7   | 5   | 4   | 12 + 10 (x2)        | 11 + 8 (x3)         | 11 + 7 (x4)           | 10 + 6 (x2) + 3 (x8)               |
| 17              | 24                      | 16  | 10  | 8   | 5   | 5   | 14 + 10 (x2)        | 11 + 9 (x3)         | 11 + 8 (x4)           | 12 + 6 (x2) + 3 (x8)               |
| 18              | 26                      | 17  | 11  | 8   | 6   | 5   | 14 + 12 (x2)        | 12 + 10 (x3)        | 12 + 9 (x4)           | 13 + 7 (x2) + 4 (x8)               |
| 19              | 27                      | 19  | 11  | 9   | 7   | 5   | 15 + 12 (x2)        | 14 + 10 (x3)        | 13 + 9 (x4)           | 13 + 8 (x2) + 4 (x8)               |
| 20              | 29                      | 19  | 12  | 9   | 7   | 5   | 15 + 13 (x2)        | 14 + 11 (x3)        | 13 + 10 (x4)          | 14 + 8 (x2) + 5 (x8)               |

## Five Characters (Hard Challenges)

|                 | Monsters of the Same CR |     |     |     |     |     | Boss Scenarios      |                     |                       |                                    |
| --------------- | ----------------------- | --- | --- | --- | --- | --- | ------------------- | ------------------- | --------------------- | ---------------------------------- |
| Character Level | 1                       | 2   | 4   | 6   | 8   | 12  | 1 Boss + 2 Monsters | 1 Boss + 3 Monsters | 1 Boss + 4 Underlings | 1 Boss + 2 Lieutenants + 8 Minions |
| 1               | 1                       | 1/2 | 1/4 | 1/8 | 0   | 0   | 1/2 + 1/4 (x2)      | 1/2 + 1/8 (x3)      | 1/4 + 1/8 (x4)        | -                                  |
| 2               | 4                       | 1   | 1/2 | 1/4 | 1/8 | 0   | 1 + 1/2 (x2)        | 1 + 1/4 (x3)        | 1 + 1/8 (x4)          | 1/2 + 1/4 (x2) + 0 (x8)            |
| 3               | 5                       | 2   | 1   | 1/2 | 1/2 | 1/4 | 2 + 1/2 (x2)        | 2 + 1/4 (x3)        | 2 + 1/4 (x4)          | 1 + 1/4 (x2) + 1/8 (x8)            |
| 4               | 6                       | 3   | 1   | 1   | 1/2 | 1/4 | 3 + 1 (x2)          | 3 + 1/2 (x3)        | 3 + 1/2 (x4)          | 2 + 1/4 (x2) + 1/8 (x8)            |
| 5               | 9                       | 5   | 2   | 2   | 1   | 1/2 | 5 + 2 (x2)          | 4 + 2 (x3)          | 5 + 1 (x4)            | 3 + 1 (x2) + 1/2 (x8)              |
| 6               | 11                      | 6   | 3   | 2   | 1   | 1/2 | 6 + 3 (x2)          | 5 + 2 (x3)          | 6 + 2 (x4)            | 4 + 1 (x2) + 1/2 (x8)              |
| 7               | 12                      | 7   | 4   | 3   | 1   | 1   | 7 + 3 (x2)          | 5 + 3 (x3)          | 6 + 2 (x4)            | 4 + 2 (x2) + 1 (x8)                |
| 8               | 13                      | 8   | 4   | 3   | 2   | 1   | 7 + 4 (x2)          | 7 + 3 (x3)          | 6 + 3 (x4)            | 5 + 2 (x2) + 1 (x8)                |
| 9               | 14                      | 8   | 5   | 3   | 2   | 1   | 8 + 4 (x2)          | 7 + 4 (x3)          | 7 + 3 (x4)            | 6 + 2 (x2) + 1 (x8)                |
| 10              | 15                      | 9   | 5   | 4   | 3   | 2   | 8 + 5 (x2)          | 8 + 4 (x3)          | 8 + 4 (x4)            | 6 + 3 (x2) + 1 (x8)                |
| 11              | 17                      | 11  | 6   | 5   | 4   | 2   | 10 + 6 (x2)         | 9 + 5 (x3)          | 8 + 5 (x4)            | 6 + 4 (x2) + 2 (x8)                |
| 12              | 19                      | 12  | 7   | 6   | 4   | 3   | 11 + 7 (x2)         | 10 + 6 (x3)         | 9 + 5 (x4)            | 8 + 4 (x2) + 2 (x8)                |
| 13              | 20                      | 13  | 8   | 7   | 5   | 3   | 11 + 8 (x2)         | 11 + 7 (x3)         | 10 + 6 (x4)           | 9 + 4 (x2) + 2 (x8)                |
| 14              | 22                      | 14  | 9   | 7   | 5   | 4   | 11 + 9 (x2)         | 12 + 7 (x3)         | 10 + 7 (x4)           | 10 + 5 (x2) + 2 (x8)               |
| 15              | 22                      | 15  | 9   | 7   | 5   | 4   | 12 + 10 (x2)        | 12 + 8 (x3)         | 12 + 7 (x4)           | 11 + 5 (x2) + 2 (x8)               |
| 16              | 24                      | 16  | 10  | 8   | 6   | 4   | 12 + 11 (x2)        | 11 + 9 (x3)         | 11 + 8 (x4)           | 11 + 7 (x2) + 2 (x8)               |
| 17              | 25                      | 17  | 11  | 9   | 7   | 5   | 15 + 11 (x2)        | 13 + 10 (x3)        | 14 + 8 (x4)           | 12 + 7 (x2) + 3 (x8)               |
| 18              | 27                      | 18  | 11  | 9   | 7   | 5   | 15 + 12 (x2)        | 14 + 10 (x3)        | 13 + 9 (x4)           | 12 + 8 (x2) + 4 (x8)               |
| 19              | 28                      | 20  | 12  | 10  | 8   | 6   | 15 + 13 (x2)        | 14 + 11 (x3)        | 13 + 10 (x4)          | 13 + 9 (x2) + 4 (x8)               |
| 20              | 29                      | 20  | 13  | 10  | 8   | 6   | 16 + 14 (x2)        | 15 + 12 (x3)        | 14 + 11 (x4)          | 14 + 9 (x2) + 5 (x8)               |

## Six Characters (Hard Challenges)

|                 | Monsters of the Same CR |    |     |     |     |     | Boss Scenarios      |                     |                       |                                    |
| --------------- | ----------------------- | -- | --- | --- | --- | --- | ------------------- | ------------------- | --------------------- | ---------------------------------- |
| Character Level | 1                       | 2  | 4   | 6   | 8   | 12  | 1 Boss + 2 Monsters | 1 Boss + 3 Monsters | 1 Boss + 4 Underlings | 1 Boss + 2 Lieutenants + 8 Minions |
| 1               | 1                       | 1  | 1/4 | 1/4 | 1/8 | 0   | 1 + 1/4 (x2)        | 1 + 1/4 (x3)        | 1 + 1/8 (x4)          | -                                  |
| 2               | 5                       | 2  | 1/2 | 1/2 | 1/4 | 1/8 | 2 + 1/2 (x2)        | 2 + 1/4 (x3)        | 2 + 1/4 (x4)          | 1/2 + 1/4 (x2) + 1/8 (x8)          |
| 3               | 7                       | 3  | 1   | 1   | 1/2 | 1/4 | 3 + 1 (x2)          | 3 + 1/2 (x3)        | 3 + 1/2 (x4)          | 1 + 1/2 (x2) + 1/4 (x8)            |
| 4               | 8                       | 4  | 2   | 1   | 1/2 | 1/2 | 4 + 2 (x2)          | 4 + 1 (x3)          | 4 + 1/2 (x4)          | 2 + 1/2 (x2) + 1/4 (x8)            |
| 5               | 10                      | 6  | 3   | 3   | 1   | 1   | 7 + 3 (x2)          | 7 + 2 (x3)          | 6 + 2 (x4)            | 3 + 1 (x2) + 1/2 (x8)              |
| 6               | 12                      | 8  | 4   | 3   | 2   | 1   | 7 + 4 (x2)          | 6 + 4 (x3)          | 6 + 3 (x4)            | 3 + 2 (x2) + 1 (x8)                |
| 7               | 13                      | 9  | 5   | 4   | 2   | 1   | 8 + 5 (x2)          | 7 + 5 (x3)          | 7 + 4 (x4)            | 5 + 2 (x2) + 1 (x8)                |
| 8               | 15                      | 11 | 6   | 4   | 3   | 2   | 8 + 6 (x2)          | 8 + 5 (x3)          | 8 + 4 (x4)            | 6 + 3 (x2) + 1 (x8)                |
| 9               | 16                      | 12 | 6   | 4   | 3   | 2   | 9 + 6 (x2)          | 8 + 6 (x3)          | 10 + 4 (x4)           | 6 + 4 (x2) + 1 (x8)                |
| 10              | 17                      | 13 | 7   | 5   | 4   | 2   | 10 + 7 (x2)         | 9 + 6 (x3)          | 10 + 5 (x4)           | 7 + 4 (x2) + 1 (x8)                |
| 11              | 19                      | 14 | 8   | 6   | 4   | 3   | 12 + 8 (x2)         | 11 + 7 (x3)         | 12 + 5 (x4)           | 8 + 4 (x2) + 2 (x8)                |
| 12              | 20                      | 16 | 9   | 7   | 5   | 3   | 14 + 9 (x2)         | 13 + 8 (x3)         | 12 + 7 (x4)           | 9 + 5 (x2) + 2 (x8)                |
| 13              | 21                      | 17 | 10  | 8   | 6   | 4   | 14 + 10 (x2)        | 13 + 9 (x3)         | 12 + 8 (x4)           | 10 + 6 (x2) + 2 (x8)               |
| 14              | 23                      | 17 | 10  | 8   | 6   | 4   | 15 + 10 (x2)        | 15 + 8 (x3)         | 13 + 8 (x4)           | 9 + 7 (x2) + 2 (x8)                |
| 15              | 24                      | 18 | 11  | 8   | 6   | 4   | 15 + 11 (x2)        | 15 + 9 (x3)         | 12 + 9 (x4)           | 9 + 7 (x2) + 3 (x8)                |
| 16              | 25                      | 19 | 11  | 9   | 7   | 4   | 15 + 12 (x2)        | 15 + 10 (x3)        | 13 + 9 (x4)           | 11 + 7 (x2) + 3 (x8)               |
| 17              | 27                      | 20 | 12  | 10  | 7   | 5   | 16 + 13 (x2)        | 16 + 11 (x3)        | 15 + 10 (x4)          | 11 + 7 (x2) + 4 (x8)               |
| 18              | 28                      | 21 | 13  | 11  | 8   | 5   | 18 + 14 (x2)        | 17 + 12 (x3)        | 15 + 11 (x4)          | 12 + 8 (x2) + 4 (x8)               |
| 19              | 29                      | 21 | 14  | 11  | 8   | 6   | 18 + 15 (x2)        | 16 + 13 (x3)        | 15 + 12 (x4)          | 13 + 9 (x2) + 4 (x8)               |
| 20              | 30                      | 22 | 15  | 13  | 9   | 7   | 20 + 16 (x2)        | 18 + 14 (x3)        | 16 + 13 (x4)          | 13 + 10 (x2) + 5 (x8)              |
